class M
{
	PI = 3.141
	
	// If it fails we return 1 in case it's used to divide something
	function tryInteger(str)
	{
		try
		{
			return (str).tointeger();
		}
		catch(err){return 1;}
	}
	
	function tryFloat(str)
	{
		try
		{
			return (str).tofloat();
		}
		catch(err){return 1.0;}
	}
	
	function sign(v)
	{
		if(v < 0)
			return -1;
		return 1;
	}
	
	function min(x,y)
	{
		if(x > y)
			return y;
		return x;
	}
	
	function max(x,y)
	{
		if(x < y)
			return y;
		return x;
	}
	
	function safe(x)
	{
		if(x == 0)
			return 1;
		return x;
	}
	
	function distance(v1,v2)
	{
		return (v1 - v2).Length();
	}
	
	function RadToDeg(Rad)
	{
		return (Rad/PI)*180;
	}
	
	function DegToRad(Deg)
	{
		local v = Deg;
		if(v < 0)
			v += 360;
		floor(v*100)/100;
		return (v/180)*PI;
	}
	
	function StringToVec(str)
	{
		try
		{
			local s_arr = split(str,",");
			s_arr.resize(3,"0");
			try
			{
				return vector(s_arr[0].tofloat(),s_arr[1].tofloat(),s_arr[2].tofloat());
			}
			catch(err)
			{
				return vector(0);
			}
		}
		catch(err)
		{
			return vector(0);
		}
	}
	
	function StringToRVec(str)
	{
		try
		{
			local s_arr = split(str,",");
			s_arr.resize(3,"0");
			try
			{
				return vector(s_arr[2].tofloat(),s_arr[1].tofloat(),s_arr[0].tofloat());
			}
			catch(err)
			{
				return vector(0);
			}
		}
		catch(err)
		{
			return vector(0);
		}
	}
	
	function VecToString(Vec)
	{
		return ((Vec.x).tostring()+","+(Vec.y).tostring()+","+(Vec.z).tostring());
	}
	
	function StringToArr(str)
	{
		try
		{
			local s_arr = split(str,";");
			return s_arr;
		}
		catch(err)
		{
			return [str];
		}
	}	
	
	function ArrToString(arr)
	{
		local s_arr = "";
		try
		{
			foreach(element in arr)
			{
				s_arr += element.tostring();
				s_arr += ";"
			}
			return s_arr;
		}
		catch(err)
		{
			return "";
		}
	}

	function RotateVec(vec,angle,axis)
	{
		local len = vec.Length();
		local norm = vec.GetNormalized();
		local res = vector()
		switch(axis)
		{
			case "x":
				res.x = norm.x;
				res.y = norm.y * cos(angle) + norm.z * sin(angle);
				res.z = -norm.y * sin(angle) + norm.z * cos(angle);
				break;
			case "y":
				res.y = norm.y;
				res.x = norm.x * cos(angle) - norm.z * sin(angle);
				res.z = norm.x * sin(angle) + norm.z * cos(angle);
				break;
			case "z":
				res.z = norm.z;
				res.x = norm.x * cos(angle) - norm.y * sin(angle);
				res.y = norm.x * sin(angle) + norm.y * cos(angle);
				break;
		}
		return res * len;
	}
	
	function GetAngleFromVec(vec)
	{
		local angle = atan2(vec.y,vec.x);
		if (angle > PI)
			angle -= 2 * PI;
		else if (angle <= -PI)
			angle += 2 * PI;
		return RadToDeg(angle);
	}
	
	function GetAngleBetweenVec(vec1,vec2)
	{
		local angle = atan2(vec2.y,vec2.x) - atan2(vec1.y,vec1.x);
		if (angle > PI)
			angle -= 2 * PI;
		else if (angle <= -PI)
			angle += 2 * PI;
		return angle;
	}
	
	function GetAngleFromDir(dir)
	{
		local TOP 	= vector(dir.x,dir.y,0);
		local RIGHT = vector(sqrt(dir.x*dir.x+dir.y*dir.y),dir.z*-1,0); // <- these should be modified so
												// they base angle on the new H orientation
												// dir.x should be rotated!
		local FRONT = vector(dir.y,dir.z,0);
	
		local H = floor(GetAngleFromVec(TOP.GetNormalized())*100)/100;
		local P = floor(GetAngleFromVec(RIGHT.GetNormalized())*100)/100;
		local B = floor(GetAngleFromVec(FRONT.GetNormalized())*100)/100;
		return vector(B,P,H);
	}
	
	function FixQuadrant(v,h)
	{
		print(">>>>>----------- " + v.tostring() + "   " + h.tostring());
		print(atan(v/safe(h)));
		local res = RadToDeg( atan(v/safe(h)) )*2;
		print(res);
		print("-----------<<<<<<<");
		if(h == 0 && v == 0) return 0;
		/*
		
		if(v < 0)
		{
			res = abs(res) + 180;
			if(h > 0) res = abs(res) + 90;
		}
		else if(h < 0) res = abs(res) + 90;*/
		return res;
	}
	
	/*function GetAngleFromDir(dir)
	{
		local Z = FixQuadrant(dir.y,dir.x);
		local X = FixQuadrant(dir.y,dir.z);
		local Y = FixQuadrant(-dir.z,dir.x);
		return vector(X,Y,Z);
	}*/
	
	function GetDirFromAngle(angle)
	{	
		local H = DegToRad(angle.z);
		local P = DegToRad(angle.y);
		local B = DegToRad(angle.x);
		
		local TOP 	= vector(floor((cos(H)*cos(P))*10)/10	,floor((sin(H)*cos(P))*10)/10	,0);
		local RIGHT = vector(floor((cos(P)*cos(H))*10)/10	,0							,floor(sin(P)*-10)/10);
		local FRONT = vector(0							,floor((cos(B)*sin(H))*10)/10	,floor(sin(B)*10)/10);
		
		return vector( 	  
						TOP.x + RIGHT.x,
						TOP.y + FRONT.y,
						RIGHT.z + FRONT.z
					).GetNormalized();
	}
	
	function FixAnglesPositive(v)
	{
		local res = v;
		if(v.x < 0)
			res.x = 360 + v.x;
		else if(v.x > 360)
			res.x = -360 + v.x;
			
		if(v.y < 0)
			res.y = 360 + v.y;
		else if(v.y > 360)
			res.y = -360 + v.y;
			
		if(v.z < 0)
			res.z = 360 + v.z;
		else if(v.z > 360)
			res.z = -360 + v.z;		
			
		return res;
	}
	
	function FixAngles180(v)
	{
		local res = v;
		if(v.x < -180)
			res.x = 360 + v.x;
		else if(v.x > 180)
			res.x = -360 + v.x;
			
		if(v.y < -180)
			res.y = 360 + v.y;
		else if(v.y > 180)
			res.y = -360 + v.y;
			
		if(v.z < -180)
			res.z = 360 + v.z;
		else if(v.z > 180)
			res.z = -360 + v.z;		
			
		return res;
	}
	
	function VEqual(v1,v2)
	{
		local state = true;
		state = state && (v1.x == v2.x);
		state = state && (v1.y == v2.y);
		state = state && (v1.z == v2.z);
		return state;
	}
}